package
{
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	
	public class TextSorter
	{
		public var allIcons:Array = new Array();
		public var allRanks:Array = new Array();
		public var allRelevances:Array = new Array();
		public var sortedIcons:Array = new Array();
		//public var lastSortedIcons:Array = new Array();
		public var sortBy:String;
		private var externalXML:XML;
		private const criteriaCount:int=5;
		private const maxAge:int=100;//in terms of days 
		private var caller:test1;
		
			
		public function TextSorter(caller1:test1)
		{
			var loader:URLLoader = new URLLoader(); 
			var request:URLRequest = new URLRequest("search1.xml"); 
			loader.load(request); 
			loader.addEventListener(Event.COMPLETE, onComplete); 
			caller = caller1;
		}
					
		public function onComplete(event:Event):void 
		{ 
			var i:int=0;
			var loader:URLLoader = event.target as URLLoader; 
			
			if (loader != null) 
			{ 
				externalXML = new XML(loader.data); 
				for (var prop:String in externalXML.child("guitar")) 
				{
					//we are filling rank values for a specific icon-> may change for increasing readability
					var xmlChildren:XMLList;
					var startIndex:int=4;
					var iconRanks:Array = new Array(criteriaCount);
					var iconInfo:Array = new Array();
					
					xmlChildren= externalXML.child("guitar")[prop].children();
					startIndex = xmlChildren.length()- criteriaCount;
						
					var relevance:Number = externalXML.child("guitar")[prop].child("relevance");
					var timeToEnd:Number = externalXML.child("guitar")[prop].child("timetoend");
					var bidRate:Number = externalXML.child("guitar")[prop].child("bidrate");
					var age:int = maxAge-timeToEnd;
			//		trace("age"+age);
					//reading icon ranks from xml*/
					for (var k:int=0; k<criteriaCount; k++)
						iconRanks[k] = parseInt(xmlChildren[startIndex+k].attribute("rank"));
					
					allRanks[prop] = iconRanks;
					allRelevances[prop] = relevance;
					
					//reading iconInfo from xml and storing it for showing it to user later
					var info:String;
					var subStrings:Array = new Array();
					for(var propIndex in xmlChildren)
					{
						subStrings = xmlChildren[propIndex].toXMLString().split(/\s+/);
						info= subStrings[0].slice(1,subStrings[0].length);
						subStrings=info.split(">");
						iconInfo[propIndex]= subStrings[0]+"="+xmlChildren[propIndex];
						
					}
					
					//for each result, create icon and store in an array
					allIcons[prop]= new TextItem(relevance,age,bidRate,iconRanks,iconInfo);
					trace(allIcons[prop]);
				}//end of for (reading all search results)

			} //end of if 
			else 
			{ 
				trace("loader is not a URLLoader!"); 
			} 
			
		//	this.Sort("Relevance (Best Match)",20);
		caller.Sort(new Event("event"));
		}//end of function (onComplete)
				
				
		public function Sort(sortparam:String,numberToShow:int){
			
			var priceshippingVal:Number=0;
			var priceVal:Number=0;
			var distanceVal:Number=0;
			var paymentVal:Number=0;
			var relevanceVal:Number=0;
			var timeVal:Number=0;
			sortedIcons = new Array();
	
			sortBy = sortparam;
			switch(sortBy){
				case "Price+Shipping: Lowest first":
					priceshippingVal=1;
				break;
				case "Price: Lowest first":
					priceVal=1;
				break;
				case "Distance: Nearest first":
					distanceVal=1;
				break;
				
				case "Payment: Paypal first":
					paymentVal=1;
				break;
				case "Relevance (Best Match)":
					relevanceVal=1;
				break;
				case "Time: Ecnding soonest":
					timeVal=1;
				break;			
			}//end of switch
			
			var sum:int=0;
			var oneIconRanks:Array;
			var scores:Array = new Array();//calculated score of each item
			//calculate score of each item based on user-inputed priority
			for (var i:int=0; i<allRanks.length;i++)
			{
				sum=0
				oneIconRanks = allRanks[i];
				sum += oneIconRanks[0]*priceshippingVal;
				sum += oneIconRanks[1]*priceVal;
				sum += oneIconRanks[2]*distanceVal;
				sum += oneIconRanks[3]*paymentVal;
				sum += (allRelevances[i]*relevanceVal);//10 is to adjust relevance to have the same effect as other factors
				sum += (allIcons[i].age*timeVal);
				scores[i]= sum;
			//	allIcons[i].score = scores[i];

			}//for i
			
			//choose top 30 ones
			//this array shows if we have previously chosen an item as one of top items
			//isChosen[i]=0->item i not chosen, =1->item i chosen
			var isChosen:Array= new Array();
			for(var j:int=0; j<allRanks.length;j++)
			{
				isChosen[j]=0;
			}
			var bestScore:int=0;
			var bestIndex:int=-1;
			for(var k:int=0; k<numberToShow;k++)
			{
				bestScore = -1;bestIndex=-1;
				for(var m:int=0; m<allRanks.length; m++)
				{
					if(scores[m]>bestScore && isChosen[m]==0)
					{
						//trace("in if"+scores[m]+">"+bestScore);
						bestScore = scores[m];
						bestIndex = m;
					}
					
				}//for m
				isChosen[bestIndex]=1;
				sortedIcons[k]=bestIndex;
			}//for k
					
		}//end of function (Sort)

	}//end of class
}//end of package